% This file reads in a csv file that continas the variable in col 1 and the
% bw paramter is col2. It then applies the biweight filter, and outputs the
% filtered variable as a single column in a csv file

%read in the variable to which we'll apply the biweight filter
X = csvread('../clean data/temp_files/bw_input.csv')
bw_parm = X(1,2)
var = X(:,1)

%add path to the matlab library
func_dir=[cd '\library']
addpath(func_dir)

%apply the filter
varmean = bw_trend(var,bw_parm)

%output varmean to csv file
csvwrite('../clean data/temp_files/bw_output.csv', varmean)

quit